package com.joshvm.ws;

import java.io.IOException;

// 分片消息结构体
public class FragmentedMessage {
	public static final int MAX_MESSAGE_SIZE = 256 * 1024; // 256KB（原1MB）
	private byte type;
	private byte[] buffer;
	private int size;

	FragmentedMessage(byte type) {
		this.type = type;
		this.buffer = new byte[MAX_MESSAGE_SIZE];
		this.size = 0;
	}

	void append(byte[] data) throws IOException {
		if (size + data.length > MAX_MESSAGE_SIZE) {
			throw new IOException("Message too large");
		}
		System.arraycopy(data, 0, buffer, size, data.length);
		size += data.length;
	}

	byte getType() {
		return type;
	}

	// 添加内存回收
	void clear() {
		size = 0;
		// 数组不释放，但重置指针
	}

	byte[] getData() {
		byte[] result = new byte[size];
		System.arraycopy(buffer, 0, result, 0, size);
		return result;
	}
}
