package com.joshvm.ws;
/**
 * 简单的Base64编码实现
 */
public class Base64 {
	 private static final char[] ALPHABET = 
	            "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
	        
	        public static String encode(byte[] data) {
	            StringBuffer result = new StringBuffer();
	            
	            for (int i = 0; i < data.length; i += 3) {
	                int b1 = data[i] & 0xFF;
	                int b2 = (i + 1 < data.length) ? (data[i + 1] & 0xFF) : 0;
	                int b3 = (i + 2 < data.length) ? (data[i + 2] & 0xFF) : 0;
	                
	                int combined = (b1 << 16) | (b2 << 8) | b3;
	                
	                result.append(ALPHABET[(combined >> 18) & 0x3F]);
	                result.append(ALPHABET[(combined >> 12) & 0x3F]);
	                result.append((i + 1 < data.length) ? ALPHABET[(combined >> 6) & 0x3F] : '=');
	                result.append((i + 2 < data.length) ? ALPHABET[combined & 0x3F] : '=');
	            }
	            
	            return result.toString();
	        }
}
