package com.joshvm.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

import org.joshvm.j2me.cellular.CellularDeviceInfo;
import org.joshvm.j2me.cellular.NetworkInfo;
import org.joshvm.util.ArrayList;


public class Utils {
	
	public static String getSimpleDay(String zone) {
		TimeZone tz = TimeZone.getTimeZone(zone);
		Calendar cld = Calendar.getInstance();
		cld.setTime(new Date(System.currentTimeMillis()));
		cld.setTimeZone(tz);

		int year = cld.get(Calendar.YEAR);
		int month = cld.get(Calendar.MONTH)+1;
		String mon = "";
		if (month < 10) {
			mon = "0" + month;
		} else {
			mon = "" + month;
		}
		int day = cld.get(Calendar.DAY_OF_MONTH);
		String dayStr = "";
		if (day < 10) {
			dayStr = "0" + day;
		} else {
			dayStr = "" + day;
		}
		String date = year + mon + dayStr;
		return date;
	}
	
	/**
	 * 等待时间  
	 * @param min 单位分钟
	 */
	public static void sleepmin(long min) {
		try {
			Thread.sleep(min * 60 * 1000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 等待时间 s 
	 * @param s 单位秒
	 */
	public static void sleep(long s) {
		try {
			Thread.sleep(s * 1000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 等待时间  ms
	 * @param ms 单位毫秒
	 */
	public static void sleepms(long ms) {
		try {
			Thread.sleep(ms);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 获取设备IMEI号
	 * 
	 * @return
	 */
	public static String getImei() {
		try {
			CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
			return infos[0].getIMEI();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return "";
	}
	
	public static String getShortImei(String imei) {
		if (imei.length() > 8) {
			return "ZS" + imei.substring(imei.length() - 8);
		} else {
			return "ZS" + imei;
		}
	}
	
	/**
	 * 设备ID 0+imei的后11位
	 * 
	 * @param imei
	 * @return
	 */
	public static String getDeviceID(String imei) {
		if (imei.length() > 11) {
			return "0" + imei.substring(imei.length() - 11);
		} else {
			return "0" + imei+"12345";
		}
	}
	
	/**
	 * 获取设备ICCID
	 * 
	 * @return
	 */
	public static String getICCID() {
		try {
			CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
			return infos[0].getICCID();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return "";
	}
	
	/**
	 * 获取设备IMSI
	 * 
	 * @return
	 */
	public static String getIMSI() {
		try {
			CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
			return infos[0].getIMSI();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return "";
	}
	
	/**
	 * 获取MCC
	 * 
	 * @return
	 */
	public static int getMCC() {
		try {
			CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
			return infos[0].getNetworkInfo().getMCC();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return 0;
	}
	
	
	/**
	 * 获取MNC
	 * 
	 * @return
	 */
	public static int getMNC() {
		try {
			CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
			return infos[0].getNetworkInfo().getMNC();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return 0;
	}
	
	/**
	 * 获取LAC
	 * 
	 * @return
	 */
	public static int getLAC() {
		try {
			CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
			return infos[0].getCellInfo().getLAC();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return 0;
	}
	
	
	/**
	 * 获取net type
	 * 
	 * @return
	 */
	public static String getNetType() {
		String s = "3G";
		try {
			CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
			int type = infos[0].getNetworkInfo().getNetworkType();
			if(type == NetworkInfo.NETWORK_TYPE_3GPP) {
				s = "4G";
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		return s;
	}
	
	/**
	 * 拆分字符串
	 * 
	 * @param str
	 * @param flag
	 * @return
	 */
	public static String[] splitString(String str, String flag) {
		ArrayList list = new ArrayList();
		while (str.indexOf(flag) != -1) {
			int index = str.indexOf(flag);
			String tmp = str.substring(0, index);
			list.add(tmp);
			str = str.substring(index + flag.length());
		}
		list.add(str);
		String[] arr = new String[list.size()];
		for (int i = 0; i < list.size(); i++) {
			arr[i] = (String) list.get(i);
		}
		return arr;
	}
	
	public static String byteArrayToHexString(byte[] bytes) {
		StringBuffer stringBuffer = new StringBuffer();
		for (int i = 0; i < bytes.length; i++) {
			if (bytes[i] < 16 && bytes[i] > -1) {
				stringBuffer.append("0" + Integer.toHexString(bytes[i] & 0xFF) + " ");
			} else {
				stringBuffer.append(Integer.toHexString(bytes[i] & 0xFF) + " ");
			}
		}
		return stringBuffer.toString();
	}

	public static String byteArrayToCompactHexString(byte[] bytes) {
		StringBuffer stringBuffer = new StringBuffer();
		int len = bytes.length > 40? 40:bytes.length;
		stringBuffer.append("["+bytes.length+"]");
		for (int i = 0; i < len; i++) {
			if (bytes[i] < 16 && bytes[i] > -1) {
				stringBuffer.append("0" + Integer.toHexString(bytes[i] & 0xFF) + " ");
			} else {
				stringBuffer.append(Integer.toHexString(bytes[i] & 0xFF) + " ");
			}
		}
		if (bytes.length > 40)
			stringBuffer.append("...");
		return stringBuffer.toString();
	}

	public static String byteArrayToHexString(byte[] bytes,int len) {
		StringBuffer stringBuffer = new StringBuffer();
		len = len < bytes.length? len:bytes.length;
		for (int i = 0; i < len; i++) {
			if (bytes[i] < 16 && bytes[i] > -1) {
				stringBuffer.append("0" + Integer.toHexString(bytes[i] & 0xFF) + " ");
			} else {
				stringBuffer.append(Integer.toHexString(bytes[i] & 0xFF) + " ");
			}
		}
		return stringBuffer.toString();
	}

	public static String byteArrayToJavaBytes(byte[] bytes, int offset,int len) {
		if (bytes == null)
			return "";

		StringBuffer stringBuffer = new StringBuffer();

		if (offset + len > bytes.length)
			len = bytes.length - offset;

		//stringBuffer.append("{"+bytes.length+":"+offset+"+"+len+"}");
		for (int i = offset; i < offset + len; i++) {
			if (bytes[i] < 16 && bytes[i] > -1) {
				stringBuffer.append("(byte)0x0" + Integer.toHexString(bytes[i] & 0xFF) + ", ");
			} else {
				stringBuffer.append("(byte)0x0"+Integer.toHexString(bytes[i] & 0xFF) + ", ");
			}
		}
		return stringBuffer.toString();
	}

	// 没空格,没分割
	public static String bytesToHexString(byte[] bytes,int offset,int len) {
		if (bytes == null)
			return "";

		StringBuffer stringBuffer = new StringBuffer();

		if (offset + len > bytes.length)
			len = bytes.length - offset;
		for (int i = offset; i < offset + len; i++) {
			if (bytes[i] < 16 && bytes[i] > -1) {
				stringBuffer.append("0" + Integer.toHexString(bytes[i] & 0xFF));
			} else {
				stringBuffer.append(Integer.toHexString(bytes[i] & 0xFF));
			}
		}
		return stringBuffer.toString();
	}

	// len: 最多打印多少,可以大于bytes实际长度,但只打印实际长度
	public static String byteArrayToHexString(byte[] bytes, int offset, int len) {
		if (bytes == null)
			return "";

		StringBuffer stringBuffer = new StringBuffer();

		if (offset + len > bytes.length)
			len = bytes.length - offset;

		stringBuffer.append("["+bytes.length+":"+offset+"+"+len+"]");
		for (int i = offset; i < offset + len; i++) {
			if (bytes[i] < 16 && bytes[i] > -1) {
				stringBuffer.append("0" + Integer.toHexString(bytes[i] & 0xFF) + " ");
			} else {
				stringBuffer.append(Integer.toHexString(bytes[i] & 0xFF) + " ");
			}
		}
		return stringBuffer.toString();
	}

	/**
	 * 转成Ascii码字符串
	 * 
	 * @param data
	 * @return
	 */
	public static String bytesToAsciiString(byte[] data) {
        if (data == null) return null;
        
        char[] chars = new char[data.length];
        for (int i = 0; i < data.length; i++) {
            // 将byte转换为无符号整数（0-255），再转为char
            chars[i] = (char) (data[i] & 0xFF);
        }
        return new String(chars);
    }
	
	/**
	 * 获取网络参数
	 * 
	 * @return
	 */
	public static  String getNetworkParameters() {
    	String propertyString = "";
        try {
        	propertyString = System.getProperty("system.network.cell.info");
        	//TODO remove
//        	return "ber=99,rsrq=14,rsrp=32,cid=266377655,tac=8530,pcid=71,rssi=-81,csq=16";
		}catch (Exception e) {
			e.printStackTrace();
		}catch (Throwable e) {
			e.printStackTrace();
		}
        return propertyString;
    }
	
	
	/**
	 * 获取充电状态
	 * 
	 * @return
	 */
	public static  int getUSBPlugin() {
    	int in = 0;
        try {
        	in = Integer.parseInt(System.getProperty("system.usb.plugin")) ;
//        	Utils.log("usb plugin : "+in);
		}catch (Exception e) {
			e.printStackTrace();
		}catch (Throwable e) {
			e.printStackTrace();
		}
        return in;
    }
	
	private static String readLine(InputStream in) throws IOException {
        int c;
        StringBuffer stringBuffer = new StringBuffer();
		for (;;) {
			c = in.read();
			if (c < 0) {
				return null;
			}
			if (c == '\r') {
				continue;
			}
			if (c == '\n') {
				break;
			}
			stringBuffer.append((char) c);
		}
		/* Return a whole line and reset the string buffer. */
		String line = stringBuffer.toString();
		return line;
        
    }
	
	/**
	 * 字符串替换
	 * 
	 * @param s1  原字符串
	 * @param target 需要被替换的字符串
	 * @param replacement 替换字符串
	 * @return 返回替换后的字符串
	 */
	public static String replace(String s1, String target, String replacement) {
	    if (target == null || target.length() == 0 || s1 == null || s1.length() == 0) {
	        return s1;
	    }
	    
	    StringBuffer result = new StringBuffer();
	    int start = 0;
	    int index;
	    
	    while ((index = s1.indexOf(target, start)) != -1) {
	        result.append(s1.substring(start, index));
	        result.append(replacement);
	        start = index + target.length();
	    }
	    
	    result.append(s1.substring(start));
	    return result.toString();
	}
    
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    
    // byte[] 转十六进制字符串
    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; j++) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0x0F];
        }
        return new String(hexChars);
    }
     
    // 十六进制字符串转 byte[]
    public static byte[] hexToBytes(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4)
                                 + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
    
    ////////////////////////////
    /**
     * 按换行符拆分字符串，兼容 \n、\r、\r\n
     */
    public static String[] splitByNewline(String input) {
        if (input == null || input.length() == 0) {
            return new String[0];
        }
        Vector lines = new Vector();
        StringBuffer sb = new StringBuffer();
        int len = input.length();
        for (int i = 0; i < len; i++) {
            char c = input.charAt(i);
            if (c == '\r') {
                lines.addElement(sb.toString());
                sb.setLength(0);
                if (i + 1 < len && input.charAt(i + 1) == '\n') {
                    i++;
                }
            } else if (c == '\n') {
                lines.addElement(sb.toString());
                sb.setLength(0);
            } else {
                sb.append(c);
            }
        }
        // 末尾没有换行符时，将最后一段加入
        if (sb.length() > 0) {
            lines.addElement(sb.toString());
        }
        String[] result = new String[lines.size()];
        lines.copyInto(result);
        return result;
    }

    public static long parseTime(String str) {
        // 格式 hhmmss.sss
        if (str == null || str.length() < 6) 
        	return 0;
        
		try {
			int hh = Integer.parseInt(str.substring(0, 2));
			int mm = Integer.parseInt(str.substring(2, 4));
			int ss = Integer.parseInt(str.substring(4, 6));
			int SSS = Integer.parseInt(str.substring(7, 10));
			return hh * 3600000 + mm * 60000 + ss * 1000 + SSS;
		} catch (Exception e) {
			return 0;
		}
    }
    
    public static void main(String[] args) {
		System.out.println(parseTime("232049.986"));
	}

    public static long parseLatitude(String str) {
        // 格式 ddmm.mmmm
        if (str == null || str.length() < 4) return 0;
        try {
            double val = Double.parseDouble(str);
            int deg = (int) (val / 100);
            double min = val - deg * 100;
            return round((deg + min / 60) * 1000000);
        } catch (Exception e) {
            return 0;
        }
    }

    public static long parseLongitude(String str) {
        // 格式 dddmm.mmmm
        if (str == null || str.length() < 5) return 0;
        try {
            double val = Double.parseDouble(str);
            int deg = (int) (val / 100);
            double min = val - deg * 100;
            return round((deg + min / 60) * 1000000);
        } catch (Exception e) {
            return 0;
        }
    }

    public static int tryParseInt(String str) {
        if (str == null || str.length() == 0) return 0;
        try {
            return Integer.parseInt(str);
        } catch (Exception e) {
        	e.printStackTrace();
            return 0;
        }
    }

    public static float tryParseFloat(String str) {
        if (str == null || str.length() == 0) return 0f;
        try {
            return Float.parseFloat(str);
        } catch (Exception e) {
        	e.printStackTrace();
            return 0f;
        }
    }
    
    // 实现double版本的round
    public static long round(double value) {
        return floor(value + 0.5);
    }
 
    // 实现float版本的round
    public static int round(float value) {
        return (int) floor(value + 0.5f);
    }
 
    // 自定义floor函数（不使用Math.floor）
    private static long floor(double value) {
        long truncated = (long) value;
        return value >= truncated ? truncated : truncated - 1;
    }
    
    /**
     * 计算校验和
     */
    public static int calculateCRC32(byte[] data, int start, int length) {
        int crc = 0xFFFFFFFF; // 初始值
        int end = start + length;
     
        for (int i = start; i < end; i++) {
            crc ^= (data[i] & 0xFF); // 字节与当前CRC异或
            for (int j = 0; j < 8; j++) {
                if ((crc & 1) != 0) {
                    crc = (crc >>> 1) ^ 0xEDB88320; // 多项式0x04C11DB7的反转表示
                } else {
                    crc = crc >>> 1;
                }
            }
        }
        return ~crc; // 最终取反
    }
    
    
	/**
	 * 获取网络状态
	 * 
	 * @return
	 */
	public static  boolean hasNet() {
    	int in = 0;
        try {
			in = Integer.parseInt(System.getProperty("system.net.status"));
		} catch (NumberFormatException e) {
			System.out.println("failed to get net.status, set to 0 as no net");
			in = 0;
		}catch (Exception e) {
			e.printStackTrace();
		}catch (Throwable e) {
			e.printStackTrace();
		}
        return in > 0;
    }

	public static void println(String x) {
		System.out.println(x);
	}

}
