package com.joshvm;

public class ConnectionParameters {
    // 协议类型常量
    public static final byte PROTOCOL_HTTP = 0x00;
    public static final byte PROTOCOL_HTTPS = 0x01;
    public static final byte PROTOCOL_MQTT = 0x02;
    public static final byte PROTOCOL_MQTTS = 0x03;
    public static final byte PROTOCOL_WEBSOCKET = 0x04;
    public static final byte PROTOCOL_WEBSOCKET_SECURE = 0x05;
    public static final byte PROTOCOL_TCP = 0x06;

    private short protocolType;
    private short httpMethod;
    private short connectId;
    private short binaryMode;
    private String url;
    private String header;
    private String username;
    private String password;
    private String token;
    private String clientId;

    private String subTopics;
    private String pubTopics;
    private String topic;

    /**
     * 构造函数
     */
    public ConnectionParameters() {
        this.protocolType = 1; // HTTP
    }

    /**
     * 设置协议类型
     */
    public void setProtocolType(short protocolType) {
        this.protocolType = protocolType;
    }

    /**
     * 获取协议类型
     */
    public short getProtocolType() {
        return protocolType;
    }

    /**
     * 设置用户名
     */
    public void setUsername(String username) {
        this.username = username != null ? username : "";
    }

    /**
     * 获取用户名
     */
    public String getUsername() {
        return username;
    }

    /**
     * 设置密码
     */
    public void setPassword(String password) {
        this.password = password != null ? password : "";
    }

    /**
     * 获取密码
     */
    public String getPassword() {
        return password;
    }

    /**
     * 设置客户端ID
     */
    public void setClientId(String clientId) {
        this.clientId = clientId != null ? clientId : "";
    }

    /**
     * 获取客户端ID
     */
    public String getClientId() {
        return clientId;
    }

    /**
     * 验证连接参数
     */
    public boolean isValid() {
        return url != null && !url.equals("");
    }

    public short getHttpMethod() {
        return httpMethod;
    }

    public void setHttpMethod(short httpMethod) {
        this.httpMethod = httpMethod;
    }

    public short getConnectId() {
        return connectId;
    }

    public void setConnectId(short connectId) {
        this.connectId = connectId;
    }

    public short getBinaryMode() {
        return binaryMode;
    }

    public void setBinaryMode(short binaryMode) {
        this.binaryMode = binaryMode;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHeader() {
        return header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getSubTopics() {
        return subTopics;
    }

    public void setSubTopics(String subTopics) {
        this.subTopics = subTopics;
    }

    public String getPubTopics() {
        return pubTopics;
    }

    public void setPubTopics(String pubTopics) {
        this.pubTopics = pubTopics;
    }

    public String getTopic() {
        return topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    /**
     * 获取协议名称
     */
    public String getProtocolName() {
        switch (protocolType) {
            case PROTOCOL_HTTP:
                return "HTTP";
            case PROTOCOL_HTTPS:
                return "HTTPS";
            case PROTOCOL_MQTT:
                return "MQTT";
            case PROTOCOL_MQTTS:
                return "MQTTS";
            case PROTOCOL_WEBSOCKET:
                return "WebSocket";
            case PROTOCOL_WEBSOCKET_SECURE:
                return "WebSocket Secure";
            default:
                return "Unknown";
        }
    }
}
