import java.io.IOException;

import org.joshvm.crypto.keystore.KeyStore;

import com.joshvm.ConnectionParameters;
import com.joshvm.utils.Logger;
import com.joshvm.utils.Utils;
import com.joshvm.ws.WebSocketClient;
import com.joshvm.ws.WebSocketListener;

public class WSDemo {
	static final String AMAZON_ROOT="MIIDQTCCAimgAwIBAgITBmyfz5m/jAo54vB4ikPmljZbyjANBgkqhkiG9w0BAQsF\n"
			+ "ADA5MQswCQYDVQQGEwJVUzEPMA0GA1UEChMGQW1hem9uMRkwFwYDVQQDExBBbWF6\n"
			+ "b24gUm9vdCBDQSAxMB4XDTE1MDUyNjAwMDAwMFoXDTM4MDExNzAwMDAwMFowOTEL\n"
			+ "MAkGA1UEBhMCVVMxDzANBgNVBAoTBkFtYXpvbjEZMBcGA1UEAxMQQW1hem9uIFJv\n"
			+ "b3QgQ0EgMTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALJ4gHHKeNXj\n"
			+ "ca9HgFB0fW7Y14h29Jlo91ghYPl0hAEvrAIthtOgQ3pOsqTQNroBvo3bSMgHFzZM\n"
			+ "9O6II8c+6zf1tRn4SWiw3te5djgdYZ6k/oI2peVKVuRF4fn9tBb6dNqcmzU5L/qw\n"
			+ "IFAGbHrQgLKm+a/sRxmPUDgH3KKHOVj4utWp+UhnMJbulHheb4mjUcAwhmahRWa6\n"
			+ "VOujw5H5SNz/0egwLX0tdHA114gk957EWW67c4cX8jJGKLhD+rcdqsq08p8kDi1L\n"
			+ "93FcXmn/6pUCyziKrlA4b9v7LWIbxcceVOF34GfID5yHI9Y/QCB/IIDEgEw+OyQm\n"
			+ "jgSubJrIqg0CAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMC\n"
			+ "AYYwHQYDVR0OBBYEFIQYzIU07LwMlJQuCFmcx7IQTgoIMA0GCSqGSIb3DQEBCwUA\n"
			+ "A4IBAQCY8jdaQZChGsV2USggNiMOruYou6r4lK5IpDB/G/wkjUu0yKGX9rbxenDI\n"
			+ "U5PMCCjjmCXPI6T53iHTfIUJrU6adTrCC2qJeHZERxhlbI1Bjjt/msv0tadQ1wUs\n"
			+ "N+gDS63pYaACbvXy8MWy7Vu33PqUXHeeE6V/Uq2V8viTO96LXFvKWlJbYK8U90vv\n"
			+ "o/ufQJVtMVT8QtPHRh8jrdkPSHCa2XV4cdFyQzR1bldZwgJcJmApzyMZFo6IQ6XU\n"
			+ "5MsI+yMRQ+hDKXJioaldXgjUkK642M4UwtBV8ob2xJNDd2ZhwLnoQdeXeGADbkpy\n"
			+ "rqXRfboQnoZsG4q5WTP468SQvvG5";
	private WebSocketClient wsc;

	public ConnectionParameters getParams(String url) {
		ConnectionParameters cp = new ConnectionParameters();
		cp.setUrl(url);
		cp.setHeader("{\"Authorization\":\"josh\"}");

		return cp;
	}
	boolean connect(String url) {
		wsc = new WebSocketClient(getParams(url), new WebSocketListener() {
			public void onOpen() {
				if (Logger.isInfo()) Logger.info("ws on open:");
			}

			public void onMessage(String message) {
				if (Logger.isInfo()) Logger.info("ws on string message: "+message);
			}

			public void onMessage(byte[] data) {
				if (Logger.isInfo()) Logger.info("ws on binary message: "+Utils.byteArrayToHexString(data));
			}

			public void onClose(int code, String reason) {
				if (Logger.isInfo()) Logger.info("ws on close:");
			}

			public void onError(Exception e) {
				if (Logger.isInfo()) Logger.info("ws on error: on err=" + e);
			}

			public void onPing(byte[] data) {
				if (Logger.isInfo()) Logger.info("ws on ping: recv ping: " + Utils.byteArrayToHexString(data));
			}

			public void onPong(byte[] data) {
				if (Logger.isInfo()) Logger.info("ws on pong: receive pong: " + Utils.byteArrayToHexString(data));
			}
		});

		for (int i=0;i<1;i++) {
			try {
				wsc.connect();
			} catch (IOException e) {
				if (Logger.isInfo()) Logger.info("ws connect: connect get " + e);
			}
			if (wsc.isOpen()) {
				return true;
			}
			Utils.sleep(1);
		}
		return false;
	}
	
	void test_ws() {
		System.out.println("test ws://ws.vi-server.org/mirror");

		connect("ws://ws.vi-server.org/mirror");
		try {
			wsc.sendText("I am josh");
		} catch (IOException e) {
			e.printStackTrace();
		}
		Utils.sleep(3);
		wsc.close();
		if (Logger.isInfo()) Logger.info("done");
	}
	void test_wss() {
		// wss连接必须先注册网站根证书,才能正常访问
		try {
			KeyStore.addWebExtraCertificate(AMAZON_ROOT);
		} catch (Exception e) {
			Logger.info("add cert get exception: " + e);
			return;
		}

		System.out.println("test wss://ws.postman-echo.com/raw");
		connect("wss://ws.postman-echo.com/raw");
		try {
			wsc.sendText("I am josh");
		} catch (IOException e) {
			e.printStackTrace();
		}
		Utils.sleep(3);
		wsc.close();
		if (Logger.isInfo()) Logger.info("done");
	}
	public static void main(String[] args) {
		WSDemo app = new WSDemo();
		app.test_ws();
		app.test_wss();
	}
}
