/*
 * Decompiled with CFR 0.152.
 */
package com.joshvm.ws;

import com.joshvm.ConnectionParameters;
import com.joshvm.utils.Logger;
import com.joshvm.ws.Base64;
import com.joshvm.ws.CircularBuffer;
import com.joshvm.ws.FragmentedMessage;
import com.joshvm.ws.OutgoingFrame;
import com.joshvm.ws.WebSocketFrame;
import com.joshvm.ws.WebSocketListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class WebSocketClient {
    private static final byte OPCODE_CONTINUATION = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private static final int STATE_CONNECTING = 0;
    private static final int STATE_OPEN = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_CLOSED = 3;
    private static final int POLL_TIMEOUT = 100;
    private static final int MAX_FRAME_SIZE = 16384;
    private static final int BUFFER_SIZE = 2048;
    private SocketConnection socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private int state = 3;
    private String gcfProtocol;
    private String url;
    private String host;
    private int port;
    private String path;
    private WebSocketListener listener;
    private Random random;
    private Thread readerThread;
    private Thread writerThread;
    private boolean running = false;
    private boolean usePolling = false;
    private FragmentedMessage activeFragment = null;
    private boolean interrupted = false;
    private final Vector sendQueue = new Vector();
    private final Object sendLock = new Object();
    private WebSocketFrame incompleteFrame = null;
    private int expectedPayloadLength = 0;
    private int receivedPayloadLength = 0;
    private byte[] framePayloadBuffer = null;
    private ConnectionParameters param;
    private final Object frameLock = new Object();
    private final CircularBuffer readBuffer = new CircularBuffer(4096);

    public WebSocketClient(ConnectionParameters param, WebSocketListener listener) {
        this(param.getUrl(), listener, false);
        this.param = param;
    }

    public WebSocketClient(String url, WebSocketListener listener, boolean usePolling) {
        this.url = url;
        this.listener = listener;
        this.usePolling = usePolling;
        this.random = new Random();
        this.parseUrl(url);
    }

    private void parseUrl(String url) {
        String hostPort;
        if (url.startsWith("ws://")) {
            url = url.substring(5);
            this.gcfProtocol = "socket://";
        } else if (url.startsWith("wss://")) {
            url = url.substring(6);
            this.gcfProtocol = "ssl://";
        } else {
            throw new IllegalArgumentException("unsupport protocol");
        }
        int slashIndex = url.indexOf(47);
        if (slashIndex != -1) {
            hostPort = url.substring(0, slashIndex);
            this.path = url.substring(slashIndex);
        } else {
            hostPort = url;
            this.path = "/";
        }
        int colonIndex = hostPort.indexOf(58);
        if (colonIndex != -1) {
            this.host = hostPort.substring(0, colonIndex);
            this.port = Integer.parseInt(hostPort.substring(colonIndex + 1));
        } else {
            this.host = hostPort;
            this.port = this.gcfProtocol.equals("ssl://") ? 443 : 80;
        }
    }

    public synchronized boolean connect() throws IOException {
        block7: {
            if (this.state != 3) {
                throw new IllegalStateException("WebSocket is already connected or connecting");
            }
            this.state = 0;
            try {
                if (Logger.isDebug()) {
                    Logger.debug("ws url=" + this.gcfProtocol + this.host + ":" + this.port);
                }
                this.socket = (SocketConnection)Connector.open((String)(String.valueOf(this.gcfProtocol) + this.host + ":" + this.port));
                this.inputStream = this.socket.openInputStream();
                this.outputStream = this.socket.openOutputStream();
                if (this.performHandshake()) break block7;
                return false;
            }
            catch (Exception e) {
                if (Logger.isInfo()) {
                    Logger.info("ws conn " + this.host + " failed for " + e);
                }
                e.printStackTrace();
                this.state = 3;
                this.cleanup();
                return false;
            }
        }
        this.state = 1;
        this.running = true;
        this.readerThread = new Thread(new Runnable(){

            public void run() {
                if (WebSocketClient.this.usePolling) {
                    WebSocketClient.this.pollingReadLoop();
                } else {
                    WebSocketClient.this.blockingReadLoop();
                }
            }
        }, "WebSocket-Reader");
        this.readerThread.start();
        this.writerThread = new Thread(new Runnable(){

            public void run() {
                WebSocketClient.this.writeLoop();
            }
        }, "WebSocket-Writer");
        this.writerThread.start();
        if (this.listener != null) {
            this.listener.onOpen();
        }
        return true;
    }

    private void fillRandomBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)this.random.nextInt(256);
            ++i;
        }
    }

    private boolean performHandshake() throws IOException {
        byte[] keyBytes = new byte[16];
        this.fillRandomBytes(keyBytes);
        String key = Base64.encode(keyBytes);
        StringBuffer request = new StringBuffer();
        request.append("GET ").append(this.path).append(" HTTP/1.1\r\n");
        request.append("Host: ").append(this.host).append(":").append(this.port).append("\r\n");
        request.append("Upgrade: websocket\r\n");
        request.append("Connection: Upgrade\r\n");
        request.append("Sec-WebSocket-Key: ").append(key).append("\r\n");
        request.append("Sec-WebSocket-Version: 13\r\n");
        String header = this.param.getHeader();
        if (header != null && header.length() > 0) {
            try {
                JSONObject o = new JSONObject(header);
                JSONArray keys = o.names();
                int i = 0;
                while (i < keys.length()) {
                    String k = (String)keys.get(i);
                    Object v = o.get(k);
                    request.append(k).append(": ").append(String.valueOf(v)).append("\r\n");
                    ++i;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        request.append("\r\n");
        if (Logger.isDebug()) {
            Logger.debug("ws client: shake request=" + request.toString());
        }
        this.outputStream.write(request.toString().getBytes());
        this.outputStream.flush();
        String response = this.readHttpResponse();
        if (Logger.isDebug()) {
            Logger.debug("ws client: shake response=" + response);
        }
        if (!response.startsWith("HTTP/1.1 101")) {
            if (Logger.isInfo()) {
                Logger.info("ws client: handshake failed: " + response);
            }
            return false;
        }
        String lowerResponse = response.toLowerCase();
        if (lowerResponse.indexOf("upgrade: websocket") == -1 || lowerResponse.indexOf("connection: upgrade") == -1) {
            if (Logger.isInfo()) {
                Logger.info("ws client: invalid handshake response");
            }
            return false;
        }
        return true;
    }

    private String readHttpResponse() throws IOException {
        int b;
        StringBuffer response = new StringBuffer();
        boolean inHeader = true;
        int consecutiveNewlines = 0;
        while (inHeader && (b = this.inputStream.read()) != -1) {
            response.append((char)b);
            if (b == 10) {
                if (++consecutiveNewlines != 2) continue;
                inHeader = false;
                continue;
            }
            if (b == 13) continue;
            consecutiveNewlines = 0;
        }
        return response.toString();
    }

    public boolean sendText(String message) throws IOException {
        byte[] data;
        if (this.state != 1) {
            return false;
        }
        if (Logger.isDebug()) {
            Logger.debug("ws client: send msg=" + message);
        }
        if ((data = message.getBytes("UTF-8")).length <= 16384) {
            this.queueFrame(new OutgoingFrame(1, data, true));
        } else {
            this.sendFragmentedMessage((byte)1, data);
        }
        return true;
    }

    public boolean sendBinary(byte[] data) throws IOException {
        if (this.state != 1) {
            return false;
        }
        if (data.length <= 16384) {
            this.queueFrame(new OutgoingFrame(2, data, true));
        } else {
            this.sendFragmentedMessage((byte)2, data);
        }
        return true;
    }

    private void sendFragmentedMessage(byte opcode, byte[] data) {
        int offset = 0;
        boolean first = true;
        while (offset < data.length) {
            int chunkSize = Math.min(16384, data.length - offset);
            byte[] chunk = new byte[chunkSize];
            System.arraycopy(data, offset, chunk, 0, chunkSize);
            byte frameOpcode = first ? opcode : (byte)0;
            boolean fin = offset + chunkSize >= data.length;
            this.queueFrame(new OutgoingFrame(frameOpcode, chunk, fin));
            offset += chunkSize;
            first = false;
        }
    }

    public void sendPing(byte[] data) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException("WebSocket is not open");
        }
        if (data == null) {
            data = new byte[]{};
        }
        if (data.length > 125) {
            throw new IllegalArgumentException("Ping payload too large");
        }
        this.queueFrame(new OutgoingFrame(9, data, true));
    }

    public void sendPong(byte[] data) {
        if (this.state == 1) {
            if (data == null) {
                data = new byte[]{};
            }
            this.queueFrame(new OutgoingFrame(10, data, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueFrame(OutgoingFrame frame) {
        Object object = this.sendLock;
        synchronized (object) {
            this.sendQueue.addElement(frame);
            this.sendLock.notify();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pollingReadLoop() {
        buffer = new byte[2048];
        if (!Logger.isDebug()) ** GOTO lbl34
        Logger.debug("ws client: pollingReadLoop start");
        try {
            if (true) ** GOTO lbl34
            do {
                block15: {
                    try {
                        available = this.inputStream.available();
                        if (Logger.isTrace()) {
                            Logger.trace("ws client: pollread input steam avaliable=" + available);
                        }
                        if (available > 0) {
                            toRead = Math.min(available, buffer.length);
                            bytesRead = this.inputStream.read(buffer, 0, toRead);
                            if (Logger.isDebug()) {
                                Logger.debug("ws client: pollread bytes " + bytesRead);
                            }
                            if (bytesRead > 0) {
                                this.readBuffer.write(buffer, 0, bytesRead);
                                this.processBufferedData();
                            }
                            break block15;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    catch (IOException e) {
                        if (Logger.isDebug()) {
                            Logger.debug("ws client: pollread end for io " + e);
                        }
                        if (!this.running) return;
                        this.notifyError(e);
                        return;
                    }
                    catch (Exception ee) {
                        if (!Logger.isDebug()) break block15;
                        Logger.debug("ws client: pollread end for " + ee);
                    }
                }
                if (!this.running || this.state != 1) return;
            } while (!this.interrupted);
            return;
        }
        finally {
            if (this.listener != null) {
                this.listener.onClose(1000, "");
            }
            this.close();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void blockingReadLoop() {
        buffer = new byte[2048];
        if (!Logger.isDebug()) ** GOTO lbl26
        Logger.debug("ws client: blockingReadLoop start");
        try {
            if (true) ** GOTO lbl26
            do {
                block12: {
                    try {
                        bytesRead = this.inputStream.read(buffer);
                        if (Logger.isDebug()) {
                            Logger.debug("ws client: blockread bytes " + bytesRead);
                        }
                        if (bytesRead == -1) {
                            return;
                        }
                        if (bytesRead > 0) {
                            this.readBuffer.write(buffer, 0, bytesRead);
                            this.processBufferedData();
                        }
                    }
                    catch (IOException e) {
                        if (Logger.isDebug()) {
                            Logger.debug("ws client: blockread end for io " + e);
                        }
                        if (!this.running) return;
                        this.notifyError(e);
                        return;
                    }
                    catch (Exception ee) {
                        if (!Logger.isDebug()) break block12;
                        Logger.debug("ws client: blockread end for " + ee);
                    }
                }
                if (!this.running || this.state != 1) return;
            } while (!this.interrupted);
            return;
        }
        finally {
            if (this.listener != null) {
                this.listener.onClose(1000, "");
            }
            this.close();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private WebSocketFrame tryReadFrame() throws IOException {
        if (this.incompleteFrame != null) {
            return this.continueReadingIncompleteFrame();
        }
        if (this.readBuffer.available() < 2) {
            return null;
        }
        int startPos = this.readBuffer.getReadPosition();
        try {
            int availablePayload;
            int b2;
            int b1;
            int firstByte = this.readBuffer.read();
            boolean fin = (firstByte & 0x80) != 0;
            byte opcode = (byte)(firstByte & 0xF);
            int secondByte = this.readBuffer.read();
            boolean masked = (secondByte & 0x80) != 0;
            int payloadLength = secondByte & 0x7F;
            if (payloadLength == 126) {
                if (this.readBuffer.available() < 2) {
                    this.readBuffer.setReadPosition(startPos);
                    return null;
                }
                b1 = this.readBuffer.read() & 0xFF;
                b2 = this.readBuffer.read() & 0xFF;
                payloadLength = b1 << 8 | b2;
            } else if (payloadLength == 127) {
                if (this.readBuffer.available() < 8) {
                    this.readBuffer.setReadPosition(startPos);
                    return null;
                }
                this.readBuffer.read();
                this.readBuffer.read();
                this.readBuffer.read();
                this.readBuffer.read();
                b1 = this.readBuffer.read() & 0xFF;
                b2 = this.readBuffer.read() & 0xFF;
                int b3 = this.readBuffer.read() & 0xFF;
                int b4 = this.readBuffer.read() & 0xFF;
                payloadLength = b1 << 24 | b2 << 16 | b3 << 8 | b4;
            }
            if (Logger.isDebug()) {
                Logger.debug("ws client: read frame header: fin=" + fin + " opcode=" + opcode + " masked=" + masked + " length=" + payloadLength);
            }
            if (payloadLength < 0 || payloadLength > 262144) {
                throw new IOException("ws client: read frame invalid payload length=" + payloadLength);
            }
            byte[] maskKey = null;
            if (masked) {
                if (this.readBuffer.available() < 4) {
                    this.readBuffer.setReadPosition(startPos);
                    return null;
                }
                maskKey = new byte[4];
                int i = 0;
                while (i < 4) {
                    maskKey[i] = (byte)this.readBuffer.read();
                    ++i;
                }
            }
            if ((availablePayload = this.readBuffer.available()) < payloadLength) {
                if (Logger.isDebug()) {
                    Logger.debug("ws client: read frame incomplete frame (" + availablePayload + "/" + payloadLength + ")");
                }
                this.incompleteFrame = new WebSocketFrame(fin, opcode, null);
                this.expectedPayloadLength = payloadLength;
                this.receivedPayloadLength = 0;
                this.framePayloadBuffer = new byte[payloadLength];
                int i = 0;
                while (i < availablePayload) {
                    this.framePayloadBuffer[this.receivedPayloadLength++] = (byte)this.readBuffer.read();
                    ++i;
                }
                if (masked && maskKey != null) {
                    i = 0;
                    while (i < this.receivedPayloadLength) {
                        int n = i;
                        this.framePayloadBuffer[n] = (byte)(this.framePayloadBuffer[n] ^ maskKey[i % 4]);
                        ++i;
                    }
                }
                this.incompleteFrame.maskKey = maskKey;
                return null;
            }
            byte[] payload = new byte[payloadLength];
            int i = 0;
            while (i < payloadLength) {
                payload[i] = (byte)this.readBuffer.read();
                ++i;
            }
            if (masked && maskKey != null) {
                i = 0;
                while (i < payloadLength) {
                    int n = i;
                    payload[n] = (byte)(payload[n] ^ maskKey[i % 4]);
                    ++i;
                }
            }
            if (Logger.isDebug()) {
                Logger.debug("ws client: read parse complete frame FIN=" + fin + ", Opcode=" + opcode + ", Length=" + payloadLength);
            }
            return new WebSocketFrame(fin, opcode, payload);
        }
        catch (Exception e) {
            this.readBuffer.setReadPosition(startPos);
            if (Logger.isInfo()) {
                Logger.info("ws client: read frame parsing error: " + e.getMessage());
            }
            e.printStackTrace();
            throw new IOException("ws client: read frame parsing failed: " + e.getMessage());
        }
    }

    private WebSocketFrame continueReadingIncompleteFrame() throws IOException {
        int remainingBytes = this.expectedPayloadLength - this.receivedPayloadLength;
        int availableBytes = this.readBuffer.available();
        if (availableBytes == 0) {
            return null;
        }
        int bytesToRead = Math.min(remainingBytes, availableBytes);
        if (Logger.isDebug()) {
            Logger.debug("ws client: read continuing incomplete frame: need " + remainingBytes + ", available " + availableBytes + ", reading " + bytesToRead);
        }
        int i = 0;
        while (i < bytesToRead) {
            this.framePayloadBuffer[this.receivedPayloadLength++] = (byte)this.readBuffer.read();
            ++i;
        }
        if (this.incompleteFrame.maskKey != null) {
            i = this.receivedPayloadLength - bytesToRead;
            while (i < this.receivedPayloadLength) {
                int n = i;
                this.framePayloadBuffer[n] = (byte)(this.framePayloadBuffer[n] ^ this.incompleteFrame.maskKey[i % 4]);
                ++i;
            }
        }
        if (this.receivedPayloadLength >= this.expectedPayloadLength) {
            if (Logger.isDebug()) {
                Logger.debug("ws client: read incomplete frame completed: total length " + this.receivedPayloadLength);
            }
            WebSocketFrame completeFrame = new WebSocketFrame(this.incompleteFrame.fin, this.incompleteFrame.opcode, this.framePayloadBuffer);
            this.incompleteFrame = null;
            this.expectedPayloadLength = 0;
            this.receivedPayloadLength = 0;
            this.framePayloadBuffer = null;
            return completeFrame;
        }
        return null;
    }

    private void handleFrame(WebSocketFrame frame) {
        if (Logger.isTrace()) {
            Logger.trace("ws client: handle frame fin=" + frame.fin + " opcode=" + frame.opcode + " length=" + frame.payload.length);
        }
        try {
            switch (frame.opcode) {
                case 1: 
                case 2: {
                    this.handleDataFrame(frame);
                    break;
                }
                case 0: {
                    this.handleContinuationFrame(frame);
                    break;
                }
                case 9: {
                    if (Logger.isDebug()) {
                        Logger.debug("ws client: handle frame recv PING");
                    }
                    this.sendPong(frame.payload);
                    if (this.listener != null) {
                        this.listener.onPing(frame.payload);
                    }
                    break;
                }
                case 10: {
                    if (Logger.isDebug()) {
                        Logger.debug("ws client: handle frame recv PONG");
                    }
                    if (this.listener != null) {
                        this.listener.onPong(frame.payload);
                    }
                    break;
                }
                case 8: {
                    if (Logger.isDebug()) {
                        Logger.debug("ws client: handle frame recv CLOSE");
                    }
                    this.handleCloseFrame(frame);
                    break;
                }
                default: {
                    if (Logger.isDebug()) {
                        Logger.debug("ws client: handle frame recv unknown opcode " + frame.opcode);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            this.notifyError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDataFrame(WebSocketFrame frame) throws IOException {
        Object object = this.frameLock;
        synchronized (object) {
            if (frame.fin) {
                if (this.activeFragment != null) {
                    if (Logger.isInfo()) {
                        Logger.info("ws client: handle data frame complete frame while fragment active!!!");
                    }
                    this.activeFragment.clear();
                    this.activeFragment = null;
                }
                this.processCompleteMessage(frame.opcode, frame.payload);
            } else {
                if (this.activeFragment != null) {
                    if (Logger.isDebug()) {
                        Logger.debug("ws client: handle data frame start new fragment while previous active");
                    }
                    this.activeFragment.clear();
                }
                this.activeFragment = new FragmentedMessage(frame.opcode);
                this.activeFragment.append(frame.payload);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleContinuationFrame(WebSocketFrame frame) throws IOException {
        Object object = this.frameLock;
        synchronized (object) {
            if (this.activeFragment == null) {
                if (Logger.isDebug()) {
                    Logger.debug("ws client: handle continue frame, ignore unexpected continuation frame");
                }
                return;
            }
            this.activeFragment.append(frame.payload);
            if (frame.fin) {
                this.processCompleteMessage(this.activeFragment.getType(), this.activeFragment.getData());
                this.activeFragment.clear();
                this.activeFragment = null;
            }
        }
    }

    private void processCompleteMessage(byte type, byte[] data) throws IOException {
        try {
            if (type == 1) {
                String message = new String(data, "UTF-8");
                if (this.listener != null) {
                    this.listener.onMessage(message);
                }
                if (Logger.isDebug()) {
                    Logger.debug("ws client: recv complete text message: length=" + message.length());
                }
            } else if (type == 2) {
                if (this.listener != null) {
                    this.listener.onMessage(data);
                }
                if (Logger.isDebug()) {
                    Logger.debug("ws client: recv complete binary message: length=" + data.length);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("UTF-8 encoding not supported");
        }
    }

    private void processBufferedData() {
        try {
            WebSocketFrame frame;
            while ((frame = this.tryReadFrame()) != null) {
                this.handleFrame(frame);
            }
            if (this.incompleteFrame != null && Logger.isDebug()) {
                Logger.debug("ws client: waiting for more data for incomplete frame: " + this.receivedPayloadLength + "/" + this.expectedPayloadLength);
            }
        }
        catch (IOException e) {
            this.incompleteFrame = null;
            this.expectedPayloadLength = 0;
            this.receivedPayloadLength = 0;
            this.framePayloadBuffer = null;
            this.notifyError(e);
        }
    }

    private void handleCloseFrame(WebSocketFrame frame) throws IOException {
        int closeCode = 1000;
        String closeReason = "";
        if (frame.payload.length >= 2) {
            closeCode = (frame.payload[0] & 0xFF) << 8 | frame.payload[1] & 0xFF;
            if (frame.payload.length > 2) {
                closeReason = new String(frame.payload, 2, frame.payload.length - 2, "UTF-8");
            }
        }
        this.state = 2;
        if (this.listener != null) {
            this.listener.onClose(closeCode, closeReason);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Handled impossible loop by adding 'first' condition
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeLoop() {
        block24: {
            block20: while (true) {
                while (this.running && this.state == 1 && !this.interrupted) {
                    OutgoingFrame frame = null;
                    Object object = this.sendLock;
                    synchronized (object) {
                        boolean bl = true;
                        do {
                            if (bl && !(bl = false) && true) continue;
                            try {
                                this.sendLock.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 20, 21, 22, 11, 13] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                                Object object2 = this.sendLock;
                                synchronized (object2) {
                                    this.sendQueue.removeAllElements();
                                }
                                this.close();
                                return;
                            }
                        } while (this.sendQueue.isEmpty() && this.running && !this.interrupted);
                        if (!this.sendQueue.isEmpty()) {
                            frame = (OutgoingFrame)this.sendQueue.elementAt(0);
                            this.sendQueue.removeElementAt(0);
                        }
                    }
                    if (frame == null) continue;
                    try {
                        this.sendFrameInternal(frame);
                        continue block20;
                    }
                    catch (IOException e) {
                        if (!this.running) break block24;
                        this.notifyError(e);
                        break block24;
                    }
                }
                break block24;
                {
                    continue block20;
                    break;
                }
                break;
            }
            catch (Throwable throwable) {
                Object object = this.sendLock;
                synchronized (object) {
                    this.sendQueue.removeAllElements();
                }
                this.close();
                throw throwable;
            }
        }
        Object object = this.sendLock;
        synchronized (object) {
            this.sendQueue.removeAllElements();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFrameInternal(OutgoingFrame frame) throws IOException {
        ByteArrayOutputStream frameData = new ByteArrayOutputStream();
        int firstByte = frame.opcode & 0xF;
        if (frame.fin) {
            firstByte |= 0x80;
        }
        frameData.write(firstByte);
        int payloadLength = frame.payload.length;
        if (payloadLength < 126) {
            frameData.write(0x80 | payloadLength);
        } else if (payloadLength < 65536) {
            frameData.write(254);
            frameData.write(payloadLength >> 8 & 0xFF);
            frameData.write(payloadLength & 0xFF);
        } else {
            frameData.write(255);
            frameData.write(0);
            frameData.write(0);
            frameData.write(0);
            frameData.write(0);
            frameData.write(payloadLength >> 24 & 0xFF);
            frameData.write(payloadLength >> 16 & 0xFF);
            frameData.write(payloadLength >> 8 & 0xFF);
            frameData.write(payloadLength & 0xFF);
        }
        byte[] maskKey = new byte[4];
        this.fillRandomBytes(maskKey);
        frameData.write(maskKey);
        int i = 0;
        while (i < frame.payload.length) {
            frameData.write(frame.payload[i] ^ maskKey[i % 4]);
            ++i;
        }
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            byte[] data = frameData.toByteArray();
            if (Logger.isDebug()) {
                Logger.debug("ws client: sendFrameInternal bytes " + data.length);
            }
            this.outputStream.write(data);
            this.outputStream.flush();
        }
    }

    private void notifyError(Exception e) {
        if (Logger.isDebug()) {
            Logger.debug("ws client: err exception=" + e);
        }
        if (Logger.isInfo()) {
            e.printStackTrace();
        }
        if (this.listener != null) {
            this.listener.onError(e);
        }
    }

    public synchronized boolean close() {
        if (Logger.isDebug()) {
            Logger.debug("ws client: close() enter");
        }
        this.close(1000, "");
        return true;
    }

    public synchronized void close(int code, String reason) {
        if (Logger.isDebug()) {
            Logger.debug("ws client: close(int,str) enter");
        }
        if (this.state == 3 || this.state == 2) {
            return;
        }
        this.running = false;
        this.interrupted = true;
        if (this.state == 1) {
            try {
                ByteArrayOutputStream closePayload = new ByteArrayOutputStream();
                closePayload.write(code >> 8 & 0xFF);
                closePayload.write(code & 0xFF);
                if (reason != null && reason.length() > 0) {
                    closePayload.write(reason.getBytes("UTF-8"));
                }
                this.queueFrame(new OutgoingFrame(8, closePayload.toByteArray(), true));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.state = 3;
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        if (Logger.isDebug()) {
            Logger.debug("ws client: clean up!");
        }
        this.incompleteFrame = null;
        this.expectedPayloadLength = 0;
        this.receivedPayloadLength = 0;
        this.framePayloadBuffer = null;
        this.interrupted = true;
        Object object = this.sendLock;
        synchronized (object) {
            this.sendLock.notifyAll();
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (Logger.isDebug()) {
            Logger.debug("ws client: start waiting read/write thread stop");
        }
        if (this.readerThread != null && this.readerThread.isAlive()) {
            try {
                long startTime = System.currentTimeMillis();
                while (this.readerThread.isAlive() && System.currentTimeMillis() - startTime < 1000L) {
                    this.readerThread.interrupt();
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException startTime) {
                // empty catch block
            }
        }
        if (Logger.isDebug()) {
            Logger.debug("ws client: read thread stopped");
        }
        if (this.writerThread != null && this.writerThread.isAlive()) {
            try {
                long startTime = System.currentTimeMillis();
                while (this.writerThread.isAlive() && System.currentTimeMillis() - startTime < 1000L) {
                    this.writerThread.interrupt();
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (Logger.isDebug()) {
            Logger.debug("ws client: write thread stopped");
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean isOpen() {
        return this.state == 1;
    }

    public void setPollingMode(boolean usePolling) {
        this.usePolling = usePolling;
    }

    private String byteToHex(byte b) {
        int value = b & 0xFF;
        String hex = Integer.toHexString(value).toUpperCase();
        return hex.length() == 1 ? "0" + hex : hex;
    }

    private void debugBuffer() {
        System.out.println("Buffer status: available=" + this.readBuffer.available() + ", readPos=" + this.readBuffer.getReadPosition());
        if (this.readBuffer.available() > 0) {
            System.out.print("Buffer content (hex): ");
            int i = 0;
            while (i < Math.min(16, this.readBuffer.available())) {
                int b = this.readBuffer.peek(i);
                if (b != -1) {
                    System.out.print(String.valueOf(this.byteToHex((byte)b)) + " ");
                }
                ++i;
            }
            System.out.println();
        }
    }
}

