/*
 * Decompiled with CFR 0.152.
 */
package com.joshvm.ws;

import java.io.IOException;

public class FragmentedMessage {
    public static final int MAX_MESSAGE_SIZE = 262144;
    private byte type;
    private byte[] buffer;
    private int size;

    FragmentedMessage(byte type) {
        this.type = type;
        this.buffer = new byte[262144];
        this.size = 0;
    }

    void append(byte[] data) throws IOException {
        if (this.size + data.length > 262144) {
            throw new IOException("Message too large");
        }
        System.arraycopy(data, 0, this.buffer, this.size, data.length);
        this.size += data.length;
    }

    byte getType() {
        return this.type;
    }

    void clear() {
        this.size = 0;
    }

    byte[] getData() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.buffer, 0, result, 0, this.size);
        return result;
    }
}

