/*
 * Decompiled with CFR 0.152.
 */
package com.joshvm.ws;

import com.joshvm.utils.Logger;
import java.io.IOException;

public class CircularBuffer {
    private byte[] buffer;
    private int readPos = 0;
    private int writePos = 0;
    private int count = 0;

    CircularBuffer(int size) {
        this.buffer = new byte[size];
    }

    public synchronized void write(byte[] data, int offset, int length) throws IOException {
        if (length > this.buffer.length - this.count) {
            this.expandBuffer(this.count + length);
        }
        int i = 0;
        while (i < length) {
            this.buffer[this.writePos] = data[offset + i];
            this.writePos = (this.writePos + 1) % this.buffer.length;
            ++this.count;
            ++i;
        }
    }

    private void expandBuffer(int minSize) {
        int newSize = Math.max(minSize * 2, this.buffer.length * 2);
        byte[] newBuffer = new byte[newSize];
        int i = 0;
        while (i < this.count) {
            newBuffer[i] = this.buffer[(this.readPos + i) % this.buffer.length];
            ++i;
        }
        this.buffer = newBuffer;
        this.readPos = 0;
        this.writePos = this.count;
        if (Logger.isTrace()) {
            Logger.trace("CircularBuffer expand size to " + newSize);
        }
    }

    public synchronized int read() {
        if (this.count == 0) {
            return -1;
        }
        int result = this.buffer[this.readPos] & 0xFF;
        this.readPos = (this.readPos + 1) % this.buffer.length;
        --this.count;
        return result;
    }

    public synchronized int available() {
        return this.count;
    }

    public synchronized int getReadPosition() {
        return this.readPos;
    }

    public synchronized void setReadPosition(int pos) {
        if (pos >= 0 && pos < this.buffer.length) {
            int skipBytes = 0;
            int currentPos = this.readPos;
            while (currentPos != pos && skipBytes < this.count) {
                currentPos = (currentPos + 1) % this.buffer.length;
                ++skipBytes;
            }
            if (skipBytes <= this.count) {
                this.readPos = pos;
                this.count -= skipBytes;
            } else {
                this.readPos = this.writePos;
                this.count = 0;
            }
        }
    }

    public synchronized int peek(int offset) {
        if (offset >= this.count || offset < 0) {
            return -1;
        }
        int pos = (this.readPos + offset) % this.buffer.length;
        return this.buffer[pos] & 0xFF;
    }
}

