/*
 * Decompiled with CFR 0.152.
 */
package com.joshvm.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import org.joshvm.j2me.cellular.CellularDeviceInfo;
import org.joshvm.util.ArrayList;

public class Utils {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static String getSimpleDay(String zone) {
        TimeZone tz = TimeZone.getTimeZone(zone);
        Calendar cld = Calendar.getInstance();
        cld.setTime(new Date(System.currentTimeMillis()));
        cld.setTimeZone(tz);
        int year = cld.get(1);
        int month = cld.get(2) + 1;
        String mon = "";
        mon = month < 10 ? "0" + month : "" + month;
        int day = cld.get(5);
        String dayStr = "";
        dayStr = day < 10 ? "0" + day : "" + day;
        String date = String.valueOf(year) + mon + dayStr;
        return date;
    }

    public static void sleepmin(long min) {
        try {
            Thread.sleep(min * 60L * 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void sleep(long s) {
        try {
            Thread.sleep(s * 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void sleepms(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String getImei() {
        try {
            CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
            return infos[0].getIMEI();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getShortImei(String imei) {
        if (imei.length() > 8) {
            return "ZS" + imei.substring(imei.length() - 8);
        }
        return "ZS" + imei;
    }

    public static String getDeviceID(String imei) {
        if (imei.length() > 11) {
            return "0" + imei.substring(imei.length() - 11);
        }
        return "0" + imei + "12345";
    }

    public static String getICCID() {
        try {
            CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
            return infos[0].getICCID();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getIMSI() {
        try {
            CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
            return infos[0].getIMSI();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int getMCC() {
        try {
            CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
            return infos[0].getNetworkInfo().getMCC();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getMNC() {
        try {
            CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
            return infos[0].getNetworkInfo().getMNC();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getLAC() {
        try {
            CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
            return infos[0].getCellInfo().getLAC();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getNetType() {
        String s = "3G";
        try {
            CellularDeviceInfo[] infos = CellularDeviceInfo.listCellularDevices();
            int type = infos[0].getNetworkInfo().getNetworkType();
            if (type == 81) {
                s = "4G";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String[] splitString(String str, String flag) {
        ArrayList list = new ArrayList();
        while (str.indexOf(flag) != -1) {
            int index = str.indexOf(flag);
            String tmp = str.substring(0, index);
            list.add((Object)tmp);
            str = str.substring(index + flag.length());
        }
        list.add((Object)str);
        String[] arr = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            arr[i] = (String)list.get(i);
            ++i;
        }
        return arr;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] < 16 && bytes[i] > -1) {
                stringBuffer.append("0" + Integer.toHexString(bytes[i] & 0xFF) + " ");
            } else {
                stringBuffer.append(String.valueOf(Integer.toHexString(bytes[i] & 0xFF)) + " ");
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToCompactHexString(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        int len = bytes.length > 40 ? 40 : bytes.length;
        stringBuffer.append("[" + bytes.length + "]");
        int i = 0;
        while (i < len) {
            if (bytes[i] < 16 && bytes[i] > -1) {
                stringBuffer.append("0" + Integer.toHexString(bytes[i] & 0xFF) + " ");
            } else {
                stringBuffer.append(String.valueOf(Integer.toHexString(bytes[i] & 0xFF)) + " ");
            }
            ++i;
        }
        if (bytes.length > 40) {
            stringBuffer.append("...");
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToHexString(byte[] bytes, int len) {
        StringBuffer stringBuffer = new StringBuffer();
        len = len < bytes.length ? len : bytes.length;
        int i = 0;
        while (i < len) {
            if (bytes[i] < 16 && bytes[i] > -1) {
                stringBuffer.append("0" + Integer.toHexString(bytes[i] & 0xFF) + " ");
            } else {
                stringBuffer.append(String.valueOf(Integer.toHexString(bytes[i] & 0xFF)) + " ");
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToJavaBytes(byte[] bytes, int offset, int len) {
        if (bytes == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (offset + len > bytes.length) {
            len = bytes.length - offset;
        }
        int i = offset;
        while (i < offset + len) {
            if (bytes[i] < 16 && bytes[i] > -1) {
                stringBuffer.append("(byte)0x0" + Integer.toHexString(bytes[i] & 0xFF) + ", ");
            } else {
                stringBuffer.append("(byte)0x0" + Integer.toHexString(bytes[i] & 0xFF) + ", ");
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String bytesToHexString(byte[] bytes, int offset, int len) {
        if (bytes == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (offset + len > bytes.length) {
            len = bytes.length - offset;
        }
        int i = offset;
        while (i < offset + len) {
            if (bytes[i] < 16 && bytes[i] > -1) {
                stringBuffer.append("0" + Integer.toHexString(bytes[i] & 0xFF));
            } else {
                stringBuffer.append(Integer.toHexString(bytes[i] & 0xFF));
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToHexString(byte[] bytes, int offset, int len) {
        if (bytes == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (offset + len > bytes.length) {
            len = bytes.length - offset;
        }
        stringBuffer.append("[" + bytes.length + ":" + offset + "+" + len + "]");
        int i = offset;
        while (i < offset + len) {
            if (bytes[i] < 16 && bytes[i] > -1) {
                stringBuffer.append("0" + Integer.toHexString(bytes[i] & 0xFF) + " ");
            } else {
                stringBuffer.append(String.valueOf(Integer.toHexString(bytes[i] & 0xFF)) + " ");
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String bytesToAsciiString(byte[] data) {
        if (data == null) {
            return null;
        }
        char[] chars = new char[data.length];
        int i = 0;
        while (i < data.length) {
            chars[i] = (char)(data[i] & 0xFF);
            ++i;
        }
        return new String(chars);
    }

    public static String getNetworkParameters() {
        String propertyString = "";
        try {
            propertyString = System.getProperty("system.network.cell.info");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return propertyString;
    }

    public static int getUSBPlugin() {
        int in = 0;
        try {
            in = Integer.parseInt(System.getProperty("system.usb.plugin"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return in;
    }

    private static String readLine(InputStream in) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int c;
            if ((c = in.read()) < 0) {
                return null;
            }
            if (c == 13) continue;
            if (c == 10) break;
            stringBuffer.append((char)c);
        }
        String line = stringBuffer.toString();
        return line;
    }

    public static String replace(String s1, String target, String replacement) {
        int index;
        if (target == null || target.length() == 0 || s1 == null || s1.length() == 0) {
            return s1;
        }
        StringBuffer result = new StringBuffer();
        int start = 0;
        while ((index = s1.indexOf(target, start)) != -1) {
            result.append(s1.substring(start, index));
            result.append(replacement);
            start = index + target.length();
        }
        result.append(s1.substring(start));
        return result.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public static byte[] hexToBytes(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static String[] splitByNewline(String input) {
        if (input == null || input.length() == 0) {
            return new String[0];
        }
        Vector<String> lines = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        int len = input.length();
        int i = 0;
        while (i < len) {
            char c = input.charAt(i);
            if (c == '\r') {
                lines.addElement(sb.toString());
                sb.setLength(0);
                if (i + 1 < len && input.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else if (c == '\n') {
                lines.addElement(sb.toString());
                sb.setLength(0);
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (sb.length() > 0) {
            lines.addElement(sb.toString());
        }
        Object[] result = new String[lines.size()];
        lines.copyInto(result);
        return result;
    }

    public static long parseTime(String str) {
        if (str == null || str.length() < 6) {
            return 0L;
        }
        try {
            int hh = Integer.parseInt(str.substring(0, 2));
            int mm = Integer.parseInt(str.substring(2, 4));
            int ss = Integer.parseInt(str.substring(4, 6));
            int SSS = Integer.parseInt(str.substring(7, 10));
            return hh * 3600000 + mm * 60000 + ss * 1000 + SSS;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static void main(String[] args) {
        System.out.println(Utils.parseTime("232049.986"));
    }

    public static long parseLatitude(String str) {
        if (str == null || str.length() < 4) {
            return 0L;
        }
        try {
            double val = Double.parseDouble(str);
            int deg = (int)(val / 100.0);
            double min = val - (double)(deg * 100);
            return Utils.round(((double)deg + min / 60.0) * 1000000.0);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long parseLongitude(String str) {
        if (str == null || str.length() < 5) {
            return 0L;
        }
        try {
            double val = Double.parseDouble(str);
            int deg = (int)(val / 100.0);
            double min = val - (double)(deg * 100);
            return Utils.round(((double)deg + min / 60.0) * 1000000.0);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static int tryParseInt(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static float tryParseFloat(String str) {
        if (str == null || str.length() == 0) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static long round(double value) {
        return Utils.floor(value + 0.5);
    }

    public static int round(float value) {
        return (int)Utils.floor(value + 0.5f);
    }

    private static long floor(double value) {
        long truncated = (long)value;
        return value >= (double)truncated ? truncated : truncated - 1L;
    }

    public static int calculateCRC32(byte[] data, int start, int length) {
        int crc = -1;
        int end = start + length;
        int i = start;
        while (i < end) {
            crc ^= data[i] & 0xFF;
            int j = 0;
            while (j < 8) {
                crc = (crc & 1) != 0 ? crc >>> 1 ^ 0xEDB88320 : (crc >>>= 1);
                ++j;
            }
            ++i;
        }
        return ~crc;
    }

    public static boolean hasNet() {
        int in = 0;
        try {
            in = Integer.parseInt(System.getProperty("system.net.status"));
        }
        catch (NumberFormatException e) {
            System.out.println("failed to get net.status, set to 0 as no net");
            in = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return in > 0;
    }

    public static void println(String x) {
        System.out.println(x);
    }
}

