/*
 * Decompiled with CFR 0.152.
 */
package com.joshvm.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;

public class Logger {
    public static final int LEVEL_TRACE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARN = 3;
    public static final int LEVEL_ERROR = 4;
    public static final int LEVEL_FATAL = 5;
    private static int currentLevel = 2;
    private static final String[] LEVEL_NAMES = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private static Hashtable loggers = new Hashtable();
    private static Object lock = new Object();
    private String module;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String module) {
        Object object = lock;
        synchronized (object) {
            Logger log = (Logger)loggers.get(module);
            if (log == null) {
                return new Logger(null);
            }
            return log;
        }
    }

    public Logger(String module) {
        this.module = module;
    }

    public static void setLevel(int level) {
        if (level >= 0 && level <= 5) {
            currentLevel = level;
        }
    }

    public static int getLevel() {
        return currentLevel;
    }

    public static boolean isTrace() {
        return currentLevel <= 0;
    }

    public static void trace(String message) {
        if (currentLevel <= 0) {
            System.out.println(message);
        }
    }

    public static boolean isDebug() {
        return 1 >= currentLevel;
    }

    public static void debug(String message) {
        if (1 >= currentLevel) {
            System.out.println(message);
        }
    }

    public static boolean isInfo() {
        return 2 >= currentLevel;
    }

    public static void info(String message) {
        if (2 >= currentLevel) {
            System.out.println(message);
        }
    }

    public static boolean isWarn() {
        return 3 >= currentLevel;
    }

    public static void warn(String message) {
        if (3 >= currentLevel) {
            System.out.println(message);
        }
    }

    public static boolean isError() {
        return 4 >= currentLevel;
    }

    public static void error(String message) {
        if (4 >= currentLevel) {
            System.out.println(message);
        }
    }

    public static boolean isFatal() {
        return 5 >= currentLevel;
    }

    public static void fatal(String message) {
        if (5 >= currentLevel) {
            System.out.println(message);
        }
    }

    public static void error(String message, Throwable throwable) {
        if (4 >= currentLevel) {
            Logger.logTimestamp(4, String.valueOf(message) + ": " + throwable.getMessage());
        }
    }

    private static void logTimestamp(int level, String message) {
        if (level >= currentLevel) {
            long time = System.currentTimeMillis();
            long seconds = time / 1000L;
            long milliseconds = time % 1000L;
            String logMessage = String.valueOf(seconds) + "." + milliseconds + ":" + message;
            if (level >= 4) {
                System.err.println(logMessage);
            } else {
                System.out.println(logMessage);
            }
        }
    }

    private static String getCurrentTimestamp() {
        long time = System.currentTimeMillis();
        long seconds = time / 1000L;
        long milliseconds = time % 1000L;
        return String.valueOf(seconds) + "." + milliseconds;
    }

    public static String getTimeStr(String zone) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(new Date());
        cld.setTimeZone(TimeZone.getDefault());
        int y = cld.get(1);
        int m = cld.get(2) + 1;
        int d = cld.get(5);
        int h = cld.get(11);
        int min = cld.get(12);
        int s = cld.get(13);
        int sss = cld.get(14);
        StringBuffer sb = new StringBuffer(25);
        if (y >= 0 && y < 1000) {
            sb.append('0');
            if (y < 100) {
                sb.append('0');
            }
            if (y < 10) {
                sb.append('0');
            }
        }
        sb.append(y).append("-");
        if (m < 10) {
            sb.append('0');
        }
        sb.append(m).append("-");
        if (d < 10) {
            sb.append('0');
        }
        sb.append(d).append(" ");
        if (h < 10) {
            sb.append('0');
        }
        sb.append(h).append(":");
        if (min < 10) {
            sb.append('0');
        }
        sb.append(min).append(":");
        if (s < 10) {
            sb.append('0');
        }
        sb.append(s).append(".");
        if (sss >= 0 && sss < 100) {
            sb.append('0');
            if (sss < 10) {
                sb.append('0');
            }
        }
        sb.append(sss).append(" ");
        return sb.toString();
    }

    public static void logMethodCall(String className, String methodName, String parameters) {
        Logger.debug("Calling method: " + className + "." + methodName + "(" + parameters + ")");
    }

    public static void logMethodReturn(String className, String methodName, String returnValue) {
        Logger.debug("Method return: " + className + "." + methodName + " = " + returnValue);
    }

    public static void logPerformance(String operation, long startTime, long endTime) {
        long duration = endTime - startTime;
        Logger.info("Performance statistics: " + operation + " spend " + duration + "ms");
    }
}

