/*
 * Decompiled with CFR 0.152.
 */
import com.joshvm.ConnectionParameters;
import com.joshvm.utils.Logger;
import com.joshvm.utils.Utils;
import com.joshvm.ws.WebSocketClient;
import com.joshvm.ws.WebSocketListener;
import java.io.IOException;
import org.joshvm.crypto.keystore.KeyStore;

public class WSDemo {
    static final String AMAZON_ROOT = "MIIDQTCCAimgAwIBAgITBmyfz5m/jAo54vB4ikPmljZbyjANBgkqhkiG9w0BAQsF\nADA5MQswCQYDVQQGEwJVUzEPMA0GA1UEChMGQW1hem9uMRkwFwYDVQQDExBBbWF6\nb24gUm9vdCBDQSAxMB4XDTE1MDUyNjAwMDAwMFoXDTM4MDExNzAwMDAwMFowOTEL\nMAkGA1UEBhMCVVMxDzANBgNVBAoTBkFtYXpvbjEZMBcGA1UEAxMQQW1hem9uIFJv\nb3QgQ0EgMTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALJ4gHHKeNXj\nca9HgFB0fW7Y14h29Jlo91ghYPl0hAEvrAIthtOgQ3pOsqTQNroBvo3bSMgHFzZM\n9O6II8c+6zf1tRn4SWiw3te5djgdYZ6k/oI2peVKVuRF4fn9tBb6dNqcmzU5L/qw\nIFAGbHrQgLKm+a/sRxmPUDgH3KKHOVj4utWp+UhnMJbulHheb4mjUcAwhmahRWa6\nVOujw5H5SNz/0egwLX0tdHA114gk957EWW67c4cX8jJGKLhD+rcdqsq08p8kDi1L\n93FcXmn/6pUCyziKrlA4b9v7LWIbxcceVOF34GfID5yHI9Y/QCB/IIDEgEw+OyQm\njgSubJrIqg0CAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMC\nAYYwHQYDVR0OBBYEFIQYzIU07LwMlJQuCFmcx7IQTgoIMA0GCSqGSIb3DQEBCwUA\nA4IBAQCY8jdaQZChGsV2USggNiMOruYou6r4lK5IpDB/G/wkjUu0yKGX9rbxenDI\nU5PMCCjjmCXPI6T53iHTfIUJrU6adTrCC2qJeHZERxhlbI1Bjjt/msv0tadQ1wUs\nN+gDS63pYaACbvXy8MWy7Vu33PqUXHeeE6V/Uq2V8viTO96LXFvKWlJbYK8U90vv\no/ufQJVtMVT8QtPHRh8jrdkPSHCa2XV4cdFyQzR1bldZwgJcJmApzyMZFo6IQ6XU\n5MsI+yMRQ+hDKXJioaldXgjUkK642M4UwtBV8ob2xJNDd2ZhwLnoQdeXeGADbkpy\nrqXRfboQnoZsG4q5WTP468SQvvG5";
    private WebSocketClient wsc;

    public ConnectionParameters getParams(String url) {
        ConnectionParameters cp = new ConnectionParameters();
        cp.setUrl(url);
        cp.setHeader("{\"Authorization\":\"josh\"}");
        return cp;
    }

    boolean connect(String url) {
        this.wsc = new WebSocketClient(this.getParams(url), new WebSocketListener(){

            public void onOpen() {
                if (Logger.isInfo()) {
                    Logger.info("ws on open:");
                }
            }

            public void onMessage(String message) {
                if (Logger.isInfo()) {
                    Logger.info("ws on string message: " + message);
                }
            }

            public void onMessage(byte[] data) {
                if (Logger.isInfo()) {
                    Logger.info("ws on binary message: " + Utils.byteArrayToHexString(data));
                }
            }

            public void onClose(int code, String reason) {
                if (Logger.isInfo()) {
                    Logger.info("ws on close:");
                }
            }

            public void onError(Exception e) {
                if (Logger.isInfo()) {
                    Logger.info("ws on error: on err=" + e);
                }
            }

            public void onPing(byte[] data) {
                if (Logger.isInfo()) {
                    Logger.info("ws on ping: recv ping: " + Utils.byteArrayToHexString(data));
                }
            }

            public void onPong(byte[] data) {
                if (Logger.isInfo()) {
                    Logger.info("ws on pong: receive pong: " + Utils.byteArrayToHexString(data));
                }
            }
        });
        int i = 0;
        while (i < 1) {
            block4: {
                try {
                    this.wsc.connect();
                }
                catch (IOException e) {
                    if (!Logger.isInfo()) break block4;
                    Logger.info("ws connect: connect get " + e);
                }
            }
            if (this.wsc.isOpen()) {
                return true;
            }
            Utils.sleep(1L);
            ++i;
        }
        return false;
    }

    void test_ws() {
        System.out.println("test ws://ws.vi-server.org/mirror");
        this.connect("ws://ws.vi-server.org/mirror");
        try {
            this.wsc.sendText("I am josh");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Utils.sleep(3L);
        this.wsc.close();
        if (Logger.isInfo()) {
            Logger.info("done");
        }
    }

    void test_wss() {
        try {
            KeyStore.addWebExtraCertificate((String)AMAZON_ROOT);
        }
        catch (Exception e) {
            Logger.info("add cert get exception: " + e);
            return;
        }
        System.out.println("test wss://ws.postman-echo.com/raw");
        this.connect("wss://ws.postman-echo.com/raw");
        try {
            this.wsc.sendText("I am josh");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Utils.sleep(3L);
        this.wsc.close();
        if (Logger.isInfo()) {
            Logger.info("done");
        }
    }

    public static void main(String[] args) {
        WSDemo app = new WSDemo();
        app.test_ws();
        app.test_wss();
    }
}

